from sklearn.datasets import make_classification
import matplotlib
# matplotlib.use('TkAgg')
# import matplotlib.pyplot as plt
import numpy as np
from sklearn import svm, linear_model
from sklearn import cluster
import csv
import pickle
import sklearn
import cvxpy as cvx
import scipy.sparse as sparse

# import cvxpy as cvx
idx_improved  = 0
x = np.array([1,2,3])

from datasets import load_dataset

import data_utils as data
import argparse
import os
import sys

from data_utils import rround, vstack
# from sklearn.externals import joblib
from PIL import Image

def save_img(img, img_size = 32,num_channel = 3,name = "output.png"):
    if len(img.shape) <=2:
        img = np.reshape(img,(-1,img_size,img_size,num_channel))
    # np.save(name, img)
    fig = np.around((img)*255)
    fig = fig.astype(np.uint8).squeeze()
    pic = Image.fromarray(fig)
    pic.save(name)

def random_sample(low,high):
    return (high-low) * np.random.random_sample() + low
    
def svm_model(**kwargs):
    return svm.LinearSVC(loss='hinge', **kwargs)
def logistic_model(**kwargs):
    return linear_model.LogisticRegression(**kwargs)

################# begin definition of some functions ################
def dist_to_boundary(theta,bias,data):
    abs_vals = np.abs(np.dot(data,theta) + bias)
    return abs_vals/(np.linalg.norm(theta,ord = 2))

def calculate_svm_loss(margins):
    # hige loss calculation
    losses = np.maximum(1-margins, 0)
    errs = (margins < 0) + 0.5 * (margins == 0)
    return np.sum(losses)/len(margins), np.sum(errs)/len(errs)

def cvx_dot(a,b):
    # return cvx.sum_entries(cvx.mul_elemwise(a, b))
    return cvx.sum(cvx.multiply(a, b))

# below is related to logistic regression loss functions
def sigmoid(scores):
    return 1 / (1 + np.exp(-scores))
def neg_log_likelihood(features, target, weights,bias):
    # this loss function form is for {-1,1} classes.
    target_copy = np.copy(target)
    target_copy[target_copy==0] = -1
    scores = target_copy * (np.dot(features, weights) + bias)
    # ll = np.sum(target*scores - np.log(1 + np.exp(scores)))
    return np.log(1+np.exp(-scores))

def log_likelihood(features, target, weights,bias):
     # this loss function form is for {0,1} classes.
    target_copy = np.copy(target)
    target_copy[target_copy == -1] = 0
    # scores = np.dot(features, weights) + bias
    # scores = target_copy * (features.dot(weights)+bias)
    scores = features.dot(weights)+bias
    #  ll = np.sum(target_copy*scores-np.log(1 + np.exp(scores)))
    ll = target_copy*scores-np.log(1 + np.exp(scores))
    
    # neg_ll = neg_log_likelihood(features, target, weights,bias)
    return ll

def compute_max_loss_diff(x,y,theta_c,bias_c,theta_p,bias_p):
    neg_ll_c = np.sum(-log_likelihood(x, y, theta_c,bias_c))
    neg_ll_p = np.sum(-log_likelihood(x, y, theta_p,bias_p))
    # neg_ll_c = neg_log_likelihood(x, y, theta_c,bias_c)
    # neg_ll_p = neg_log_likelihood(x, y, theta_p,bias_p)

    return neg_ll_c - neg_ll_p

def compute_ramp_loss(x,y,theta,bias,k):
    margins = y*(x.dot(theta)+bias)
    hinge_like_k = (1/k) * np.maximum(k-margins, 0)
    hinge_like_0 = (1/k) * np.maximum(-margins, 0)
    return  hinge_like_k-hinge_like_0,hinge_like_k,hinge_like_0

def compute_loss(model_name, x,y,theta,bias,margin_only=False):
    if model_name == 'svm':
        margins = y*(x.dot(theta)+bias)
        if margin_only:
            return margins
        else:
            return np.maximum(1-margins, 0)
    else:
        return -log_likelihood(x,y,theta,bias)
        # return neg_log_likelihood(x, y,theta,bias) 
    
def bounded_surrgate_with_k(x,y,k,theta,bias):
    margins = y*(x.dot(theta)+bias)
    if k is not None:
        return (1/k) * (np.maximum(k-margins, 0) - np.maximum(-margins, 0))
    else:
        # just return the regular hinge loss
        return np.maximum(1-margins, 0)

def get_grads(model_name,theta,bias,X,Y):
    # this gradient is calculated based on dot product, so X and Y should be of shape (?,D) and (?,)
    # the returned gradient is their average
    if model_name == 'lr':
        margins = Y * (X.dot(theta) + bias)
        if sparse.issparse(X):
            SMY = -sigmoid(-margins).reshape((-1, 1)) * Y.reshape((-1, 1))
            grad_theta = np.array(np.mean(
                sparse.diags(SMY.reshape(-1)).dot(X),
                axis=0)).reshape(-1)
        else:
            grad_theta = np.mean(
                -sigmoid(-margins).reshape((-1, 1)) * Y.reshape((-1, 1)) * X,
                axis=0)
        grad_bias = np.mean(
            -sigmoid(-margins).reshape((-1, 1)) * Y.reshape((-1, 1)),
            axis=0)[0]
    elif model_name == 'svm':
        margins = Y * (X.dot(theta) + bias)
        sv_indicators = margins < 1
        if sparse.issparse(X):
            grad_theta = np.sum(
                -sparse.diags(np.reshape(Y[sv_indicators], (-1))).dot(
                    X[sv_indicators, :]) , axis=0) / X.shape[0]
            grad_theta = np.array(grad_theta).reshape(-1)
        else:
            grad_theta = np.sum(-np.reshape(Y[sv_indicators],(-1,1)) * X[sv_indicators,:],axis=0)/X.shape[0]
        grad_bias = np.sum( -np.reshape(Y[sv_indicators], (-1, 1)),axis=0) / X.shape[0] 
        grad_bias = grad_bias[0]
    return grad_theta, grad_bias 

def lr_grad_to_x(theta_c,bias_c,theta_p,bias_p,x,y):
    if np.amin(y) ==  -1:
        # the grad computation below requires {0,1}
        y_cp = (y+1)/2
    else:
        y_cp = np.copy(y)
    scores = np.dot(theta_c, x) + bias_c
    prediction_c = sigmoid(scores[0])
    scores = np.dot(theta_p, x) + bias_p
    prediction_p = sigmoid(scores[0])  

    # Update weights with gradient
    output_error_signal_c = prediction_c - y_cp 
    output_error_signal_p = prediction_p - y_cp

    # the gradient is with respect to negative log likelihood
    # print(output_error_signal_c,theta_c.shape,x.shape)
    gradient_c = np.dot(theta_c, output_error_signal_c)
    gradient_p = np.dot(theta_p, output_error_signal_p)
    grads = (gradient_c - gradient_p)
    return grads

def custom_search_max_loss_pt(verbose,model_name,theta,bias,classes,x_lim_tuples,args,lr=1e-5,num_steps=3000,trials=10,optimizer = 'adam'):
    # deply gradient descend strategy to search for apprximately max loss
    # optimizer: 'gd': gradent descend; 'adagrad', 'adam'; empirically, adam seems to converge much faster than the other two

    # for reproducibility
    np.random.seed(args.rand_seed)
    x_pos_tuple, x_neg_tuple = x_lim_tuples  
    d = theta.shape[0]
    # setup the initial point for optimization and gradients
    # note: ll = np.sum( y*prediction - np.log(1 + np.exp(prediction)) ) 
    
    best_loss = -1e10  
    for y in classes:
        max_loss_for_label = -1e10
        if verbose:
            print("--- Testing with label ----:",y)
        if y == -1:
            y_tmp = 0
            x_min, x_max = x_neg_tuple
        else:
            y_tmp = y
            x_min, x_max = x_pos_tuple

        for trial in range(trials):
            # print("------ trial {}------".format(trial))
            if args.dataset == 'dogfish':
                x = np.array([random_sample(x_min[i],x_max[i]) for i in range(len(x_min))])
            else:
                x = np.array([random_sample(x_min,x_max) for i in range(d)])

            if optimizer == 'adagrad':
                # store the square of gradients
                # print("Utilizing Adagrad Optimizer")
                grads_squared = np.zeros(d)
                initial_accumulator_value = 0.001
                grads_squared.fill(initial_accumulator_value)
                epsilon = 1e-7
            elif optimizer == 'adam':
                # print("Utilizing Adam Optimizer")
                grads_first_moment = np.zeros(d)
                grads_second_moment = np.zeros(d)
                beta1 = 0.9
                beta2 = 0.999
                epsilon = 1e-8
            
            prev_loss = 1e10
            for step in range(num_steps):
                grads = get_grads(model_name,theta,bias,x,y_tmp)
                if optimizer == 'gd':
                    x += lr * grads
                elif optimizer == 'adagrad':
                    """Weights update using adagrad.
                    grads2 = grads2 + grads**2
                    w' = w - lr * grads / (sqrt(grads2) + epsilon)
                    """
                    grads_squared = grads_squared + grads**2
                    x = x + lr * grads / (np.sqrt(grads_squared) + epsilon)
                elif optimizer == 'adam':
                    """Weights update using Adam.
                    
                    g1 = beta1 * g1 + (1 - beta1) * grads
                    g2 = beta2 * g2 + (1 - beta2) * g2
                    g1_unbiased = g1 / (1 - beta1**time)
                    g2_unbiased = g2 / (1 - beta2**time)
                    w = w - lr * g1_unbiased / (sqrt(g2_unbiased) + epsilon)
                    """
                    time = step + 1
                    grads_first_moment = beta1 * grads_first_moment + \
                                            (1. - beta1) * grads
                    grads_second_moment = beta2 * grads_second_moment + \
                                            (1. - beta2) * grads**2
                    
                    grads_first_moment_unbiased = grads_first_moment / (1. - beta1**time)
                    grads_second_moment_unbiased = grads_second_moment / (1. - beta2**time)
                    
                    x = x + lr * grads_first_moment_unbiased /(np.sqrt(grads_second_moment_unbiased) + epsilon)
                # projection step to ensure it is within bounded norm
                x = np.clip(x,x_min,x_max)

                # max loss found so far
                if args.dataset == 'adult':
                    # round the continuous values into discrete one to ensure it's meaningful
                    x_tmp = np.copy(x)
                    x_tmp[4:57] = np.rint(x[4:57]) 
                    max_loss = np.sum(compute_loss(model_name,x_tmp,y_tmp,theta,bias))
                    max_loss_real = np.sum(compute_loss(model_name,x,y_tmp,theta,bias))
                else:
                    max_loss = np.sum(compute_loss(model_name,x,y_tmp,theta,bias))
                    max_loss_real = max_loss
                
                if max_loss_for_label < max_loss:
                    max_loss_for_label = max_loss

                if best_loss < max_loss:
                    # print("update best loss from {} to {}".format(best_loss,max_loss))
                    best_loss = max_loss
                    best_loss_real = max_loss_real
                    best_y = y
                    if args.dataset == 'adult':
                        best_x = x_tmp
                    else:
                        best_x = x

                if np.abs(prev_loss - max_loss) < args.custom_opt_tol:
                    # print("Enough convergence")
                    # print("steps: {}  max loss: {:.4f}  best_loss: {:.4f}".format(step+1, max_loss, best_loss))        
                    break
                prev_loss = max_loss
        if verbose:
            print("Selected max loss with label {}: {}".format(y,max_loss_for_label))
    if verbose:
        print("Final max loss with label {}: {}".format(best_y,best_loss))
    return best_loss, best_loss_real, np.transpose(np.array([best_x])), best_y

def margin_model_search_max_loss_pt_contin(verbose,model_name,theta,bias,classes,x_lim_tuples,args, theta_tar=None, bias_tar=None, C=None,\
                                           use_slab=False,use_sphere=False,defense_pars=None):
    x_pos_tuple, x_neg_tuple = x_lim_tuples  
    if use_slab or use_sphere:
        assert defense_pars is not None
        class_map, centroids, centroid_vec, sphere_radii, slab_radii = defense_pars
    # cvx variables and params
    if args.dataset == "adult":
        # used for the binary constraints, however, the constraints are not used here
        # because the original data violates these constraints 
        arr = np.array([0]*(theta.shape[0]))
        arr[4:12] = 1
        cvx_work_class = cvx.Parameter(theta.shape[0], value = arr)
        arr = np.array([0]*(theta.shape[0]))
        arr[12:27] = 1
        cvx_education = cvx.Parameter(theta.shape[0], value = arr)
        arr = np.array([0]*(theta.shape[0]))
        arr[27:33] = 1
        cvx_martial = cvx.Parameter(theta.shape[0], value = arr)
        arr = np.array([0]*(theta.shape[0]))
        arr[33:47] = 1
        cvx_occupation = cvx.Parameter(theta.shape[0], value = arr)
        arr = np.array([0]*(theta.shape[0]))
        arr[47:52] = 1
        cvx_relationship = cvx.Parameter(theta.shape[0], value = arr)
        arr = np.array([0]*(theta.shape[0]))
        arr[52:57] = 1
        cvx_race = cvx.Parameter(theta.shape[0], value = arr)

    best_loss = -1e10  
    for y in classes:
        if y == -1:
            x_min, x_max = x_neg_tuple
        else:
            x_min, x_max = x_pos_tuple

        if args.dataset == 'adult':
            cvx_x_real = cvx.Variable(4)
            cvx_x_binary = cvx.Variable(theta.shape[0]-4, boolean=True)
            cvx_x = cvx.hstack([cvx_x_real,cvx_x_binary])
        else:
            cvx_x = cvx.Variable(theta.shape[0])

        cvx_theta = cvx.Parameter(theta.shape[0])
        cvx_bias = cvx.Parameter(1)
        if use_slab or use_sphere:
            cvx_centroid = cvx.Parameter(theta.shape[0])
            cvx_centroid_vec = cvx.Parameter(theta.shape[0])
            cvx_slab_radius = cvx.Parameter(1)
            cvx_sphere_radius = cvx.Parameter(1)

            # assign the variable values
            cvx_centroid.value = centroids[class_map[y]].reshape(-1)
            cvx_centroid_vec.value = centroid_vec.reshape(-1)
            cvx_slab_radius = [slab_radii[class_map[y]]]
            cvx_sphere_radius.value = [sphere_radii[class_map[y]]]

        # assign param values
        cvx_theta.value = theta
        cvx_bias.value = bias

        max_loss = -1
        cvx_loss = -y * (cvx_dot(cvx_theta,cvx_x) + cvx_bias) 

        cvx_constraints = []
        if theta_tar is not None:
            # improved version of min-max attack that leverages target model
            assert bias_tar is not None
            assert C is not None
            cvx_tar_theta = cvx.Parameter(theta.shape[0])
            cvx_tar_bias = cvx.Parameter(1)
            cvx_tar_theta.value = theta_tar
            cvx_tar_bias.value = bias_tar
        
            # constraints for lr and svm should be processed differently
            if model_name == 'svm':
                # augment constraints
                cvx_constraints.append(
                1- y * (cvx_dot(cvx_tar_theta,cvx_x) + cvx_tar_bias) <= C)
            elif model_name == 'lr':
                cvx_constraints.append(
                - y * (cvx_dot(cvx_tar_theta,cvx_x) + cvx_tar_bias) <=  np.log(np.exp(C)-1))                

        if x_neg_tuple is not None or x_pos_tuple is not None:
            cvx_constraints.append(cvx_x >= x_min)
            cvx_constraints.append(cvx_x <= x_max)

        if use_sphere:
            cvx_constraints.append(cvx.pnorm(cvx_x - cvx_centroid, 2) ** 2 <= cvx_sphere_radius ** 2)
            # self.constraints.append(cvx.pnorm(self.cvx_x_neg - self.cvx_centroid_neg, 2) ** 2 < self.cvx_sphere_radius_neg ** 2)
        if use_slab:
            cvx_constraints.append(cvx_dot(cvx_centroid_vec, cvx_x - cvx_centroid) <= cvx_slab_radius)
            cvx_constraints.append(-cvx_dot(cvx_centroid_vec, cvx_x - cvx_centroid) <= cvx_slab_radius)

        cvx_objective = cvx.Maximize(cvx_loss)
        cvx_prob = cvx.Problem(cvx_objective,cvx_constraints)
        # try:
        max_loss = cvx_prob.solve(verbose=False, solver=cvx.GUROBI) 
        # max_loss = max(tmp_sol,0)
        max_loss_real = max_loss
        max_loss_x = np.array(cvx_x.value)

        if best_loss < max_loss:
            best_loss = max_loss
            best_loss_real = max_loss_real
            best_loss_y = y
            best_x = np.array([max_loss_x])
        if verbose:
            print("loss with lab {}: {}".format(y,max_loss))
    
        # round the found example to the nearest integer
        if args.dataset in ['enron','imdb']:
            best_x =  rround(best_x) # np.rint(best_x)
    if verbose:
        print("Optimal value found from optimization with label {}: {}".format(best_loss_y,best_loss_real))

    return best_loss, best_loss_real, best_x, best_loss_y

def svm_search_max_loss_diff_pt(clean_model,poison_model,y,x_lim_tuple,args,verbose=False,\
                                use_slab=False,use_sphere=False,defense_pars=None):
    
    if use_slab or use_sphere:
        assert defense_pars is not None
        class_map, centroids, centroid_vec, sphere_radii, slab_radii = defense_pars

    theta_c = clean_model.coef_.reshape(-1)
    bias_c = clean_model.intercept_
    
    theta_p = poison_model.coef_.reshape(-1)
    bias_p = poison_model.intercept_
    x_min, x_max = x_lim_tuple

    if verbose and args.dataset != "dogfish":
        print("min and max values of datapoint",x_min,x_max)

    # print("*******model weights************")
    # print("clean model weights:",theta_c,bias_c)
    # print("poison model weights:",theta_p,bias_p)

    # cvx variables and params
    if args.dataset == "adult":
        # used for the binary constraints
        arr = np.array([0]*(theta_c.shape[0]-4))
        arr[0:8] = 1
        cvx_work_class = cvx.Parameter(theta_c.shape[0]-4, value = arr)
        arr = np.array([0]*(theta_c.shape[0]-4))
        arr[8:23] = 1
        cvx_education = cvx.Parameter(theta_c.shape[0]-4, value = arr)
        arr = np.array([0]*(theta_c.shape[0]-4))
        arr[23:29] = 1
        cvx_martial = cvx.Parameter(theta_c.shape[0]-4, value = arr)
        arr = np.array([0]*(theta_c.shape[0]-4))
        arr[29:43] = 1
        cvx_occupation = cvx.Parameter(theta_c.shape[0]-4, value = arr)
        arr = np.array([0]*(theta_c.shape[0]-4))
        arr[43:48] = 1
        cvx_relationship = cvx.Parameter(theta_c.shape[0]-4, value = arr)
        arr = np.array([0]*(theta_c.shape[0]-4))
        arr[48:53] = 1
        cvx_race = cvx.Parameter(theta_c.shape[0]-4, value = arr)

        cvx_x_real = cvx.Variable(4)
        cvx_x_binary = cvx.Variable(theta_c.shape[0]-4, boolean=True)
        # cvx_x_binary = cvx.Bool(theta_c.shape[0]-4) # suitable for version 0.4 abd before
        cvx_x = cvx.hstack([cvx_x_real,cvx_x_binary])

        # # used for the binary constraints
        # arr = np.array([0]*(theta_c.shape[0]))
        # arr[4:12] = 1
        # cvx_work_class = cvx.Parameter(theta_c.shape[0], value = arr)
        # arr = np.array([0]*(theta_c.shape[0]))
        # arr[12:27] = 1
        # cvx_education = cvx.Parameter(theta_c.shape[0], value = arr)
        # arr = np.array([0]*(theta_c.shape[0]))
        # arr[27:33] = 1
        # cvx_martial = cvx.Parameter(theta_c.shape[0], value = arr)
        # arr = np.array([0]*(theta_c.shape[0]))
        # arr[33:47] = 1
        # cvx_occupation = cvx.Parameter(theta_c.shape[0], value = arr)
        # arr = np.array([0]*(theta_c.shape[0]))
        # arr[47:52] = 1
        # cvx_relationship = cvx.Parameter(theta_c.shape[0], value = arr)
        # arr = np.array([0]*(theta_c.shape[0]))
        # arr[52:57] = 1
        # cvx_race = cvx.Parameter(theta_c.shape[0], value = arr)
        # cvx_x = cvx.Variable(theta_c.shape[0])
    else:
        cvx_x = cvx.Variable(theta_c.shape[0])
    
    cvx_theta_c = cvx.Parameter(theta_c.shape[0])
    cvx_bias_c = cvx.Parameter(1)
    cvx_theta_p = cvx.Parameter(theta_c.shape[0])
    cvx_bias_p = cvx.Parameter(1)
    # assign param values
    cvx_theta_c.value = theta_c
    cvx_bias_c.value = bias_c
    cvx_theta_p.value = theta_p
    cvx_bias_p.value = bias_p

    # add defenses if needed to illustrate things
    if use_slab or use_sphere:
        cvx_centroid = cvx.Parameter(theta_c.shape[0])
        cvx_centroid_vec = cvx.Parameter(theta_c.shape[0])
        cvx_slab_radius = cvx.Parameter(1)
        cvx_sphere_radius = cvx.Parameter(1)

        # assign the variable values
        cvx_centroid.value = centroids[class_map[y]].reshape(-1)
        cvx_centroid_vec.value = centroid_vec.reshape(-1)
        cvx_slab_radius = [slab_radii[class_map[y]]]
        cvx_sphere_radius.value = [sphere_radii[class_map[y]]]


    max_loss = -1e10
    # # cvx objective related definitions
    # case 1: !0 loss for clean model, 0 for poison model
    # print("explore case 1:")
    cvx_loss = 1-y * (cvx_dot(cvx_theta_c,cvx_x) + cvx_bias_c) 
    cvx_constraints = [
        y * (cvx_dot(cvx_theta_c,cvx_x) + cvx_bias_c) <= 1,
        y * (cvx_dot(cvx_theta_p,cvx_x) + cvx_bias_p) >= 1
    ]

    if x_lim_tuple is not None:
        if args.dataset == 'adult':
            # cvx_constraints.append(cvx_x_real >= x_min)
            # cvx_constraints.append(cvx_x_real <= x_max)
            cvx_constraints.append(cvx_x >= x_min)
            cvx_constraints.append(cvx_x <= x_max)            
        else:
            cvx_constraints.append(cvx_x >= x_min)
            cvx_constraints.append(cvx_x <= x_max)

    if use_sphere:
        cvx_constraints.append(cvx.pnorm(cvx_x - cvx_centroid, 2) ** 2 <= cvx_sphere_radius ** 2)
    if use_slab:
        cvx_constraints.append(cvx_dot(cvx_centroid_vec, cvx_x - cvx_centroid) <= cvx_slab_radius)
        cvx_constraints.append(-cvx_dot(cvx_centroid_vec, cvx_x - cvx_centroid) <= cvx_slab_radius)

    # # original Adult data does not strictly obey the following constraints 
    # # and we comment them for fair comparison
    # if args.dataset == 'adult':
    #     # binary featutre constraints: beacuse of one-hot encoding
    #     cvx_constraints.append(cvx_dot(cvx_work_class, cvx_x_binary) <= 1)
    #     cvx_constraints.append(cvx_dot(cvx_education, cvx_x_binary) == 1)
    #     cvx_constraints.append(cvx_dot(cvx_martial, cvx_x_binary) == 1)
    #     cvx_constraints.append(cvx_dot(cvx_occupation , cvx_x_binary) == 1)
    #     cvx_constraints.append(cvx_dot(cvx_relationship, cvx_x_binary) == 1)
    #     cvx_constraints.append(cvx_dot(cvx_race, cvx_x_binary) == 1)

    #     # cvx_constraints.append(cvx_dot(cvx_work_class, cvx_x) == 1)
    #     # cvx_constraints.append(cvx_dot(cvx_education, cvx_x) == 1)
    #     # cvx_constraints.append(cvx_dot(cvx_martial, cvx_x) == 1)
    #     # cvx_constraints.append(cvx_dot(cvx_occupation , cvx_x) == 1)
    #     # cvx_constraints.append(cvx_dot(cvx_relationship, cvx_x) == 1)
    #     # cvx_constraints.append(cvx_dot(cvx_race, cvx_x) == 1)
    
    failed_val = -1e10

    cvx_objective = cvx.Maximize(cvx_loss)
    cvx_prob = cvx.Problem(cvx_objective,cvx_constraints)
    try:
        tmp_sol = cvx_prob.solve(verbose=verbose, solver=cvx.GUROBI) 
        # print("successfully solved case 1 without errors!")
    except cvx.error.SolverError:
        # if verbose:
        print("Case 1 debugging Info:")
        print("labels:",y)
        norm_diff = np.sqrt(np.linalg.norm(cvx_theta_c.value-cvx_theta_p.value)**2+(cvx_bias_c.value - cvx_bias_p.value)**2)
        print("norm difference:",norm_diff)
        tmp_sol = failed_val

    if verbose:
        print("optimal value found from optimization in case 1:",tmp_sol)
    # obtain the max loss and best point for poisoning
    if tmp_sol!=failed_val:
        # print("not a failed case for case 1")
        if max_loss < cvx_prob.value:
            # print("valid solution found and replacing the max loss in case1!")
            max_loss = cvx_prob.value
            max_loss_x = np.array(cvx_x.value)
            if verbose:
                print("max loss is changed to:",max_loss)
    else:
        max_loss = -1e10
        max_loss_x = 0

    # print("explore case 2:")
    # case 2: !0 loss for clean model, !0 for poison model
    cvx_loss = y * (cvx_dot(cvx_theta_p-cvx_theta_c,cvx_x) + (cvx_bias_p - cvx_bias_c))
    cvx_constraints = [
        y * (cvx_dot(cvx_theta_c,cvx_x) + cvx_bias_c) <= 1,
        y * (cvx_dot(cvx_theta_p,cvx_x) + cvx_bias_p) <= 1
    ]
    if x_lim_tuple is not None:
        if args.dataset == 'adult':
            # cvx_constraints.append(cvx_x_real >= x_min)
            # cvx_constraints.append(cvx_x_real <= x_max)
            cvx_constraints.append(cvx_x >= x_min)
            cvx_constraints.append(cvx_x <= x_max)
        else:
            cvx_constraints.append(cvx_x >= x_min)
            cvx_constraints.append(cvx_x <= x_max)

    if use_sphere:
        cvx_constraints.append(cvx.pnorm(cvx_x - cvx_centroid, 2) ** 2 <= cvx_sphere_radius ** 2)
    if use_slab:
        cvx_constraints.append(cvx_dot(cvx_centroid_vec, cvx_x - cvx_centroid) <= cvx_slab_radius)
        cvx_constraints.append(-cvx_dot(cvx_centroid_vec, cvx_x - cvx_centroid) <= cvx_slab_radius)
        
    # # commented below also because original data violates the 
    # # strict constramts below
    # if args.dataset == 'adult':
    #     # binary featutre constraints: beacuse of one-hot encoding
    #     cvx_constraints.append(cvx_dot(cvx_work_class, cvx_x_binary) == 1)
    #     cvx_constraints.append(cvx_dot(cvx_education, cvx_x_binary) == 1)
    #     cvx_constraints.append(cvx_dot(cvx_martial, cvx_x_binary) == 1)
    #     cvx_constraints.append(cvx_dot(cvx_occupation , cvx_x_binary) == 1)
    #     cvx_constraints.append(cvx_dot(cvx_relationship, cvx_x_binary) == 1)
    #     cvx_constraints.append(cvx_dot(cvx_race, cvx_x_binary) == 1)

    #     # cvx_constraints.append(cvx_dot(cvx_work_class, cvx_x) == 1)
    #     # cvx_constraints.append(cvx_dot(cvx_education, cvx_x) == 1)
    #     # cvx_constraints.append(cvx_dot(cvx_martial, cvx_x) == 1)
    #     # cvx_constraints.append(cvx_dot(cvx_occupation , cvx_x) == 1)
    #     # cvx_constraints.append(cvx_dot(cvx_relationship, cvx_x) == 1)
    #     # cvx_constraints.append(cvx_dot(cvx_race, cvx_x) == 1)

    cvx_objective = cvx.Maximize(cvx_loss)
    cvx_prob = cvx.Problem(cvx_objective,cvx_constraints)
    try:
        tmp_sol = cvx_prob.solve(verbose=False, solver=cvx.GUROBI) 
        exit_flag = False
        # print("successfully solved case 2 without errors!")
    except cvx.error.SolverError:
        # if verbose:
        print("Case 2 debugging Info:")
        print("labels:",y)
        norm_diff = np.sqrt(np.linalg.norm(cvx_theta_c.value-cvx_theta_p.value)**2+(cvx_bias_c.value - cvx_bias_p.value)**2)
        print("norm difference:",norm_diff)
        tmp_sol = failed_val

        exit_flag = True

    if verbose:
        print("optimal value found from optimization in case 2:",tmp_sol)
    # obtain the max loss and best point for poisoning
    if tmp_sol!=failed_val:
        # print("not a failed case for case 2",max_loss,tmp_sol)
        if max_loss < tmp_sol:# cvx_prob.value:
            # print("valid solution found and replacing the max loss in case2!")
            max_loss = cvx_prob.value
            max_loss_x = np.array(cvx_x.value)
            if verbose:
                print("max loss is changed to:",max_loss)
    else:
        max_loss_x = np.zeros(theta_c.shape)

    # case 4: 0 for both cases, do not need to calculate.
    if args.dataset not in ["dogfish","enron","filtered_enron","cifar10_89"]:
        assert np.amax(max_loss_x) <= (x_max + float(x_max)/100), "the data point {}, max value {}".format(max_loss_x,np.amax(max_loss_x))
        assert np.amin(max_loss_x) >= (x_min - 0.00001), "the data point {}, min value {}".format(max_loss_x,np.amin(max_loss_x))

    if args.dataset in ['enron','imdb']:
        max_loss_x =  rround(max_loss_x) # np.rint(max_loss_x)

    return max_loss, max_loss_x

def lr_search_max_loss_pt(d,theta_c,bias_c,y,x_lim_tuples,args,lr=1e-5,num_steps=3000,trials=10,optimizer = 'adam',verbose=False,
theta_tar=None, bias_tar=None, C=None):
    # deply gradient descend strategy to search for apprximately max loss
    # optimizer: 'gd': gradent descend; 'adagrad', 'adam'; empirically, adam seems to converge much faster than the other two
    if verbose:
        print("--- Testing with label ----:",y)
    # point for logistic regression
    x_pos_tuple, x_neg_tuple = x_lim_tuples  
    if y == -1:
        y_tmp = 0
        x_min, x_max = x_neg_tuple
    else:
        y_tmp = y
        x_min, x_max = x_pos_tuple
    
    # for reproducibility
    np.random.seed(args.rand_seed)
    
    # setup the initial point for optimization and gradients
    # note: ll = np.sum( y*prediction - np.log(1 + np.exp(prediction)) ) 
    best_loss = -1e10
    # best_loss1 = -1e10
    for trial in range(trials):
        # print("------ trial {}------".format(trial))
        if args.dataset in ['dogfish','enron','cifar10_05','imdb']:
            x = np.array([random_sample(x_min[i],x_max[i]) for i in range(len(x_min))])
        else:
            x = np.array([random_sample(x_min,x_max) for i in range(d)])
        if optimizer == 'adagrad':
            # store the square of gradients
            # print("Utilizing Adagrad Optimizer")
            grads_squared = np.zeros(d)
            initial_accumulator_value = 0.001
            grads_squared.fill(initial_accumulator_value)
            epsilon = 1e-7
        elif optimizer == 'adam':
            # print("Utilizing Adam Optimizer")
            grads_first_moment = np.zeros(d)
            grads_second_moment = np.zeros(d)
            beta1 = 0.9
            beta2 = 0.999
            epsilon = 1e-8
        
        prev_loss = 1e10
        for step in range(num_steps):
            # if step == 0:
            #     max_loss = compute_max_loss_diff(x, y_tmp, theta_c,bias_c,theta_p,bias_p)
            #     print("(random) initial max loss value:",max_loss)
            # predictions of current and target models
            scores = np.dot(theta_c, x) + bias_c
            prediction_c = sigmoid(scores)
            # prediction_c = sigmoid(scores[0])

            # Update weights with gradient
            output_error_signal_c = prediction_c - y_tmp 

            # the gradient is with respect to negative log likelihood
            # print(output_error_signal_c,theta_c.shape,x.shape)
            gradient_c = np.dot(theta_c, output_error_signal_c)
            if theta_tar is not None:
                # for constrained logistic regression optimization, only thing to do is to use lagrangian augmentation to solve the problem
                # hence, parameter "C" will be used as a regularization strength constant
                assert bias_tar is not None
                assert C is not None
                scores = np.dot(theta_tar, x) + bias_tar
                prediction_tar = sigmoid(scores[0])
                output_error_signal_tar = prediction_tar - y_tmp 
                gradient_tar = np.dot(theta_tar, output_error_signal_tar)
            else:
                gradient_tar = 0
                C = 0
            grads = gradient_c - C * gradient_tar
            if optimizer == 'gd':
                x += lr * grads
            elif optimizer == 'adagrad':
                """Weights update using adagrad.
                grads2 = grads2 + grads**2
                w' = w - lr * grads / (sqrt(grads2) + epsilon)
                """
                grads_squared = grads_squared + grads**2
                x = x + lr * grads / (np.sqrt(grads_squared) + epsilon)
            elif optimizer == 'adam':
                """Weights update using Adam.
                
                g1 = beta1 * g1 + (1 - beta1) * grads
                g2 = beta2 * g2 + (1 - beta2) * g2
                g1_unbiased = g1 / (1 - beta1**time)
                g2_unbiased = g2 / (1 - beta2**time)
                w = w - lr * g1_unbiased / (sqrt(g2_unbiased) + epsilon)
                """
                time = step + 1
                grads_first_moment = beta1 * grads_first_moment + \
                                        (1. - beta1) * grads
                grads_second_moment = beta2 * grads_second_moment + \
                                        (1. - beta2) * grads**2
                
                grads_first_moment_unbiased = grads_first_moment / (1. - beta1**time)
                grads_second_moment_unbiased = grads_second_moment / (1. - beta2**time)
                
                x = x + lr * grads_first_moment_unbiased /(np.sqrt(grads_second_moment_unbiased) + epsilon)
            # print(y_tmp,output_error_signal_c, output_error_signal_p)
            # projection step to ensure it is within bounded norm
            x = np.clip(x,x_min,x_max)
            
            # print("added: min max",np.amin(lr * (gradient_c - gradient_p)),np.amax(lr * (gradient_c - gradient_p)))
            # print("before: min max",np.amin(x),np.amax(x))

            # max loss found so far
            if args.dataset == 'adult':
                # round the continuous values into discrete one to ensure it's meaningful
                x_tmp = np.copy(x)
                x_tmp[4:57] = np.rint(x[4:57]) 
                max_loss = np.sum(compute_loss('lr',x_tmp, y_tmp, theta_c,bias_c))
                max_loss_real = np.sum(compute_loss('lr',x, y_tmp, theta_c,bias_c))
            else:
                max_loss = np.sum(compute_loss('lr',x, y_tmp, theta_c,bias_c))
                max_loss_real = max_loss
            
            if best_loss < max_loss:
                best_loss = max_loss
                best_loss_real = max_loss_real
                if args.dataset == 'adult':
                    best_x = x_tmp
                else:
                    best_x = x

            if np.abs(prev_loss - max_loss) < 1e-7:
                break

            prev_loss = max_loss
    best_x = np.array([best_x])
    if args.dataset in ['enron','imdb']:
        best_x = rround(best_x)

    return best_loss, best_loss_real, best_x

def lr_search_max_loss_diff_pt(d,curr_model,target_model,y,x_lim_tuple,args,lr=1e-5,tol_param=1e-7,num_steps=3000,\
trials=10,optimizer = 'adam',verbose=False,candidate_set=None):
    # deply gradient descend strategy to search for apprximately max loss
    # optimizer: 'gd': gradent descend; 'adagrad', 'adam'; empirically, adam seems to converge much faster than the other two
    if verbose:
        print("--- Testing with label ----:",y)
    # point for logistic regression
    if y == -1:
        y_tmp = 0
    else:
        y_tmp = y
    
    # for reproducibility
    np.random.seed(args.rand_seed)

    theta_c = curr_model.coef_.reshape(-1)
    bias_c = curr_model.intercept_
    theta_p = target_model.coef_.reshape(-1)
    bias_p = target_model.intercept_
    x_min, x_max = x_lim_tuple

    best_loss = -1e10
    # best_loss1 = -1e10
    for trial in range(trials):
        # print("------ trial {}------".format(trial))
        if args.dataset in ['dogfish','cifar10_05']:
            # print(np.amin(x_min),np.amax(x_min))
            # print(np.amin(x_max),np.amax(x_max))
            x = np.array([random_sample(x_min[i],x_max[i]) for i in range(len(x_min))])
        elif args.dataset in ['enron','imdb']:
            rand_idx = np.random.choice(np.arange(candidate_set.shape[0]))
            x = np.squeeze(candidate_set[rand_idx].toarray())
        else:
            x = np.array([random_sample(x_min,x_max) for i in range(d)])

        if optimizer == 'adagrad':
            # store the square of gradients
            grads_squared = np.zeros(d)
            initial_accumulator_value = 0.001
            grads_squared.fill(initial_accumulator_value)
            epsilon = 1e-7
        elif optimizer == 'adam':
            grads_first_moment = np.zeros(d)
            grads_second_moment = np.zeros(d)
            beta1 = 0.9
            beta2 = 0.999
            epsilon = 1e-8
        
        prev_loss = 1e10

        for step in range(num_steps):
            # if step == 0:
            #     max_loss = compute_max_loss_diff(x, y_tmp, theta_c,bias_c,theta_p,bias_p)
            #     print("(random) initial max loss value:",max_loss)
            # predictions of current and target models
            scores = np.dot(theta_c, x) + bias_c

            prediction_c = sigmoid(scores[0])
            scores = np.dot(theta_p, x) + bias_p
            prediction_p = sigmoid(scores[0])  

            # Update weights with gradient
            output_error_signal_c = prediction_c - y_tmp 
            output_error_signal_p = prediction_p - y_tmp 

            # the gradient is with respect to negative log likelihood
            # print(output_error_signal_c,theta_c.shape,x.shape)
            gradient_c = np.dot(theta_c, output_error_signal_c)
            gradient_p = np.dot(theta_p, output_error_signal_p)
            grads = (gradient_c - gradient_p)

            if optimizer == 'gd':
                x += lr * grads
            elif optimizer == 'adagrad':
                """Weights update using adagrad.
                grads2 = grads2 + grads**2
                w' = w - lr * grads / (sqrt(grads2) + epsilon)
                """
                grads_squared = grads_squared + grads**2
                x = x + lr * grads / (np.sqrt(grads_squared) + epsilon)
            elif optimizer == 'adam':
                """Weights update using Adam.
                
                g1 = beta1 * g1 + (1 - beta1) * grads
                g2 = beta2 * g2 + (1 - beta2) * g2
                g1_unbiased = g1 / (1 - beta1**time)
                g2_unbiased = g2 / (1 - beta2**time)
                w = w - lr * g1_unbiased / (sqrt(g2_unbiased) + epsilon)
                """
                time = step + 1
                grads_first_moment = beta1 * grads_first_moment + \
                                        (1. - beta1) * grads
                grads_second_moment = beta2 * grads_second_moment + \
                                        (1. - beta2) * grads**2
                
                grads_first_moment_unbiased = grads_first_moment / (1. - beta1**time)
                grads_second_moment_unbiased = grads_second_moment / (1. - beta2**time)
                
                x = x + lr * grads_first_moment_unbiased /(np.sqrt(grads_second_moment_unbiased) + epsilon)
            # projection step to ensure it is within bounded norm
            x = np.clip(x,x_min,x_max)

            # max loss found so far
            if args.dataset == 'adult':
                # round the continuous values into discrete one to ensure it's meaningful
                x_tmp = np.copy(x)
                x_tmp[4:57] = np.rint(x[4:57]) 
                max_loss = compute_max_loss_diff(x_tmp, y_tmp, theta_c,bias_c,theta_p,bias_p)
                max_loss_real = compute_max_loss_diff(x, y_tmp, theta_c,bias_c,theta_p,bias_p)
            else:
                max_loss = compute_max_loss_diff(x, y_tmp, theta_c,bias_c,theta_p,bias_p)
                max_loss_real = max_loss
            
            if best_loss < max_loss:
                best_loss = max_loss
                best_loss_real = max_loss_real
                if args.dataset == 'adult':
                    best_x = x_tmp
                else:
                    best_x = x

            # print(max_loss,prev_loss)
            if np.abs(prev_loss - max_loss) < tol_param:
                # print("Enough convergence")
                # print("steps: {}  max loss: {:.4f}  best_loss: {:.4f}".format(step+1, max_loss, best_loss))
                break

            prev_loss = max_loss
    if verbose:
        print("selected max loss with label {}: {}".format(y,best_loss))

    if args.dataset in ['enron','imdb']:
        best_x = rround(best_x) # np.rint(best_x)
    return best_loss, best_loss_real, best_x # np.transpose(np.array([best_x]))

def train_model(X,Y,args,fit_intercept=True):
    check_transfer=args.check_transfer
    if args.model_type == 'svm':
        if not check_transfer:
            ScikitModel = svm_model
        else:
            ScikitModel = logistic_model
    elif args.model_type == 'lr':
        if not check_transfer:
            ScikitModel = logistic_model
        else:
            ScikitModel = svm_model

    C = 1.0 / (X.shape[0] * args.weight_decay)
    model = ScikitModel(
        C=C,
        tol=1e-10,
        fit_intercept=fit_intercept,
        random_state=24,
        verbose=False,
        max_iter = 10000)
    model.fit(X, Y)
    return model

def test_model(X_train_p,Y_train_p,X_train,Y_train,X_test,Y_test,model,args,verbose=True):
    if X_train_p.shape[0] > X_train.shape[0]:
        X_poison = X_train_p[X_train.shape[0]:,:]
        Y_poison = Y_train_p[X_train.shape[0]:]
    else:
        X_poison = Y_poison = None

    theta = model.coef_.reshape(-1)
    bias = model.intercept_
    # calculate the total model acc
    total_train_acc = model.score(X_train_p,Y_train_p)
    if X_poison is not None:
        poison_train_acc = model.score(X_poison,Y_poison)
    else:
        poison_train_acc = 0
    clean_train_acc = model.score(X_train,Y_train)
    clean_test_acc = model.score(X_test,Y_test)

    train_losses = compute_loss(args.model_type,X_train_p,Y_train_p,theta,bias)
    total_train_loss = np.mean(train_losses)# *X_train_p.shape[0]
    
    if verbose:
        print("[total] train_acc:{}, train loss:{}".format(total_train_acc,total_train_loss))
    
    if X_poison is not None:
        train_losses = compute_loss(args.model_type,X_poison,Y_poison,theta,bias)
        poison_train_loss = np.mean(train_losses)# *X_train_p.shape[0]
        if verbose:
            print("[total] train_acc:{}, train loss:{}".format(poison_train_acc,poison_train_loss))
    else:
        poison_train_loss = 0
    
    train_losses = compute_loss(args.model_type,X_train,Y_train,theta,bias)
    clean_train_loss = np.mean(train_losses) # *X_train.shape[0]
    if verbose:
        print("[clean] train_acc:{:}, train loss:{}".format(clean_train_acc,clean_train_loss))
    test_losses = compute_loss(args.model_type,X_test,Y_test,theta,bias)
    clean_test_loss = np.mean(test_losses)# *X_test.shape[0]
    if verbose:
        print("[clean] test_acc:{:}, test loss:{}".format(clean_test_acc,clean_test_loss))

    return total_train_loss, poison_train_loss, clean_train_loss, clean_test_loss, total_train_acc, poison_train_acc, clean_train_acc, clean_test_acc

def get_needed_dirs(args,X_train):
    if args.dataset == 'cifar10_89':
        dataset = '{}_{}'.format(args.dataset,args.epoch)
    else:
        dataset = args.dataset

    fig_dir_name = 'files/results/figures/{}/{}/{}/{}'.format(dataset,args.model_type,\
            args.weight_decay,args.rand_seed)
    if not os.path.isdir(fig_dir_name):
        os.makedirs(fig_dir_name)

    result_dir = 'files/results/attack_results/{}/{}/{}/{}'.format(dataset,args.model_type,args.weight_decay,args.rand_seed)
    if not os.path.isdir(result_dir):
        os.makedirs(result_dir)

    if not args.use_train:
        train_or_test_data = 'use_test'
    else:
        train_or_test_data = 'use_train'
    # ../indiscriminate_attack_clean/

    tar_model_dir = 'files/target_classifiers/{}/{}/{}/{}'.format(dataset,args.model_type,\
        args.weight_decay,train_or_test_data)
    tar_model_dir_mat = 'influence_attack/data'
    if not os.path.isdir(tar_model_dir):
        os.makedirs(tar_model_dir)

    return result_dir, fig_dir_name, tar_model_dir, tar_model_dir_mat
